#include <adit_logging.h>
#include <signal.h>
#include "BdclSmoketest.h"

LOG_IMPORT_CONTEXT(tbdcl)

namespace adit { namespace bdcl {

using namespace std;
using namespace utility;

AutoSmoketest::AutoSmoketest()
{
    static int _counter = 0;
    _counter++;
    if (_counter > 1)
        fprintf(stderr, "AutoSmoketest object shall not be used twice");

    timerCreated = false;
    timerid = 0;
    stError =  NOERROR; //default
}

AutoSmoketest::~AutoSmoketest()
{
    deleteSignalTimer();
}

void AutoSmoketest::createSignalTimer()
{
    struct sigevent sev;
    sev.sigev_notify = SIGEV_SIGNAL;
    sev.sigev_signo  = SIGINT;
    sev.sigev_value.sival_ptr = &timerid;

    if (timer_create(CLOCK_MONOTONIC, &sev, &timerid) == -1)
        {
          fprintf(stderr,"AutoSmoketest::createSignalTimer timer_create failed ");
        }
    else
      {
        timerCreated=true;
      }
}
void AutoSmoketest::startSignalTimer()
{
    struct itimerspec its;

    its.it_value.tv_sec     = stTimeout;
    its.it_value.tv_nsec    = 0;
    its.it_interval.tv_sec  = 0;
    its.it_interval.tv_nsec = 0;

    if (timer_settime(timerid, 0, &its, nullptr) == -1)
        fprintf(stderr, "AutoSmoketest::startSignalTimer timer_settime failed ");
}
void AutoSmoketest::deleteSignalTimer()
{
  if(timerCreated)
    {
      timer_delete(timerid);
      timerCreated = false;
    }
}
std::string& AutoSmoketest::getErrorString(void)
{
   if (stError == NODEVICE)
   {
       errString = "NO DEVICE CONNECTED";
   }
   else if (stError == AOAPNOTSUPPORTED)
   {
       errString = "DEVICE DOES NOT SUPPORT AOAP MODE";
   }
   else if (stError == DEVICEALREADYINAOAP)
   {
       //todo:handle this error
       errString = "DEVICE ALREADY IN AOAP MODE";
   }
   else if (stError == GSTINTERNAL)
   {
       errString = "notifyErrorCallback() Received. INTERNAL GSTREAMER ERROR" ;
   }
   else if (stError == INVALIDCHANNELID)
   {
       errString = "Invalid Channel ID";
   }
   else if (stError == NOERROR)
   {
       errString = "VIDEO FRAME RENDERED" ;
   }
    return errString;
}


} } //// namespace adit bdcl
